<?php
    /**
    *
    * copyright (c) 2013-2019 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    * 	Classe che gestisce la presenza della popup in una determinata categoria,
    *   o della home
    */

    class GestorePopup {
        private $db;
        private $categoria;
        private $popup;
        
        function __construct($db, $categoria) {
            $this->db = $db;
            $this->categoria = $categoria;
            
            $query = "SELECT * FROM geec_popup WHERE categoria={$this->categoria}";
            $ris   = $db->eseguiQueryLettura($query);
            if($ris->num_rows>0) {
                $this->popup = $ris->fetch_assoc();
            }
            else {
                $this->popup = NULL;
            }
        }

        function stampaPopup() {
            if($this->popup!=NULL) {
                if($this->popup["testo"]!="" && $this->popup["immagine"]!="") {
                    $this->stampaImmagineETesto();
                }
                else if($this->popup["testo"]!="") {
                    $this->stampaSoloTesto();
                }
                else {
                    $this->stampaSoloImmagine();
                }
            }
        }
        
        function stampaSoloImmagine() {
            echo"<div class=\"modal fade\" id=\"modalPopup\" tabindex=\"-1\" role=\"dialog\" aria-labelledby=\"centrata\" aria-hidden=\"true\">
                <div class=\"modal-dialog modal-dialog-centered modal-lg\" role=\"document\">
                    <div class=\"modal-content rounded-0\">
                        <div class=\"modal-body p-0\">";
                            if($this->popup["link"]!="") {
                                echo"<a href={$this->popup["link"]}>";
                            }
                            echo"<img class=\"img-fluid w-100\" src=\"{$this->popup["immagine"]}\">";
                            if($this->popup["link"]!="") {
                                echo"</a>";
                            }
                        echo"</div>
                    </div>
                </div>
              </div>";
        }
        
        function stampaSoloTesto() {
            echo"<div class=\"modal fade\" id=\"modalPopup\" tabindex=\"-1\" role=\"dialog\" aria-labelledby=\"modalSemplice\" aria-hidden=\"true\">
                    <div class=\"modal-dialog modal-lg\" role=\"document\">
                        <div class=\"modal-content rounded-0\">
                            <div class=\"modal-header\">
                                <button type=\"button\" class=\"close\" data-dismiss=\"modal\" aria-label=\"Close\">
                                    <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>
                            <div class=\"modal-body\">
                                <p class=\"mt-2\">{$this->popup["testo"]}</p>
                            </div>
                            <div class=\"modal-footer\">
                                <button type=\"button\" data-dismiss=\"modal\" class=\"btn btn-primary sharp\">Chiudi</button>
                            </div>
                        </div>
                    </div>
                  </div>";
        }
        
        function stampaImmagineETesto() {
            echo"<div class=\"modal fade\" id=\"modalPopup\" tabindex=\"-1\" role=\"dialog\" aria-labelledby=\"modalSemplice\" aria-hidden=\"true\">
                    <div class=\"modal-dialog modal-lg\" role=\"document\">
                        <div class=\"modal-content rounded-0\">
                            <div class=\"modal-header\">
                                <button type=\"button\" class=\"close\" data-dismiss=\"modal\" aria-label=\"Close\">
                                    <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>
                            <div class=\"modal-body\">
                                <img class=\"img-fluid w-100\" src=\"{$this->popup["immagine"]}\">
                                <p class=\"mt-2\">{$this->popup["testo"]}</p>
                            </div>
                            <div class=\"modal-footer\">
                                <button type=\"button\" data-dismiss=\"modal\" class=\"btn btn-primary sharp\">Chiudi</button>
                            </div>
                        </div>
                    </div>
                  </div>";
        }
        
        function javascriptPopup() {
            if($this->popup!=NULL) {
                $secondi = $this->popup["secondi"] * 1000;
                echo"<script>
                    function mostraPopup(){
                        $('#modalPopup').modal('show');
                    };
                    
                    $(window).on('load',function(){
                        var timer = window.setTimeout(mostraPopup,$secondi);
                    });
                </script>";
            }
        }
                
        function getDb() {
            return $this->db;
        }

        function getCategoria() {
            return $this->categoria;
        }

        function getPopup() {
            return $this->popup;
        }
        
        function setDb($db) {
            $this->db = $db;
        }

        function setCategoria($categoria) {
            $this->categoria = $categoria;
        }
        
        function setPopup($popup) {
            $this->popup = $popup;
        }
    }